<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>RomaHost - Modern Web Hosting</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Hostco - Modern Web Hosting & WHMCS Template" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="section-hero" class="v-center" aria-label="section" data-bgimage='url(images/background/3.jpg)'>
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-10 offset-lg-1 text-center">
                            <div class="spacer-single"></div>
                            <h1 class="very-big wow fadeInUp">Best <span class="id-color">hosting</span> and <span class="id-color">domain</span> for your
                                <span class="clearfix d-lg-none d-block"></span>
                                <span class="typed-strings">
                                    <p>business.</p>
                                    <p>portfolio.</p>
                                    <p>store.</p>
                                </span>
                                <span class="typed"></span>
                            </h1>
                        </div>
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <p class="wow fadeInUp" data-wow-delay=".2s">High performance secured hosting for your website. Don't lose anymore clients for the slowest speed of your hosting service. Get hosting package now!</p>
                        </div>
                        <div class="col-lg-8 offset-lg-2 text-center">
                            <form action='https://romahost.com.br/domainchecker.php' class="row wow fadeInUp" data-wow-delay=".4s" id='form_sb' method="post" name="form_sb">
                                <div class="col">
                                    <div class="spacer-10"></div>
                                    <input class="form-control" id='domain_name' name='domain' placeholder="enter domain name" type='text'> <a id="btn-submit" href="javascript:;" onclick="document.getElementById('form_sb').submit();"><i class="arrow_right"></i></a>
                                    <div class="clearfix"></div>
                                    <div class="spacer-10"></div>
                                    <div class="domain-ext pos-left">
                                        <div class="ext wow flipInY" data-wow-delay="1.1s">
                                            <h4 class="id-color">.com</h4>
                                            $9.99/year
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.2s">
                                            <h4 class="id-color">.net</h4>
                                            $9.99/year
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.3s">
                                            <h4 class="id-color">.site</h4>
                                            $2.99/year
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.4s">
                                            <h4 class="id-color">.shop</h4>
                                            $3.90/year
                                        </div>
                                        <div class="ext wow flipInY" data-wow-delay="1.5s">
                                            <h4 class="id-color">.store</h4>
                                            $5.99/year
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </section>

            <section class="no-top">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 wow fadeInUp">
                            <img class="img-fluid anim-up-down" src="images/misc/server.png" alt="">
                        </div>
                        <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <h2>New functionality brings maximum <span class="color-gradient">power</span> to your
                                    website.</h2>
                                <p>At Romahost, we pride ourselves on being the ultimate destination for unbeatable
                                    web hosting services and round-the-clock support, all bundled with unlimited
                                    features for your convenience.</p>
                                <div class="row">
                                    <div class="col-md-5">
                                        <ul class="ul-style-2">
                                            <li>
                                                <h4>Instant Activation</h4>
                                            </li>
                                            <li>
                                                <h4>99.9% Uptime</h4>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-md-5">
                                        <ul class="ul-style-2">
                                            <li>
                                                <h4>Reliable Hardware</h4>
                                            </li>
                                            <li>
                                                <h4>24 / 7 Support</h4>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="spacer-half"></div>
                                <a class="btn-main" href="#section-pricing">Shared Hosting</a>
                                <a class="btn-main" href="https://trycpanel.net/">Demo cPanel</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-pricing" class="no-top" data-bgimage='url(images/background/1.jpg) top'>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3">
                            <div class="text-center">
                                <h5 class="s2">Hosting Plan</h5>
                                <h2>Choose Perfect <span class="id-color">Web Hosting</span> Package For You</h2>
                                <div class="spacer-20"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row wow fadeInUp">
                        <div class="col text-center">
                            <div class="switch-set">
                                <div>Monthly Plan</div>
                                <div><input id="sw-1" class="switch" type="checkbox"></div>
                                <div>Yearly Plan</div>
                                <div class="spacer-20"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row de_pricing-tables shadow-soft g-0">
                        <div class="col-xl-4 col-lg-6">
                            <div class="de_pricing-table type-2">
                                <div class="d-head">
                                    <h3>Lite</h3>
                                    <p>Ideal solution for beginners.</p>
                                </div>
                                <div class="d-price">
                                    <h4 class="opt-1">3.00$<span>/Month</span></h4>
                                    <h4 class="opt-2">28.00$<span>/Year</span></h4>
                                    <p>Normally <s>9.00$ / Month</s></p>
                                </div>
                                <div class="d-action">
                                    <a href="#PRODUCTLINK" class="btn-main opt-1 w-100">Get Monthly Plan</a>
                                    <a href="#PRODUCTLINK" class="btn-main opt-2 w-100">Get Yearly Plan</a>
                                    <p>re-new at same rate</p>
                                </div>
                                <div class="d-group">
                                    <h4>Top Features</h4>
                                    <ul class="d-list">
                                        <li>1 Website</li>
                                        <li>Unmetered Storage</li>
                                        <li>Unmetered Bandwidth</li>
                                        <li>24/7 Customer Support</li>
                                    </ul>
                                </div>
                                <div class="d-group">
                                    <h4>Also Includes</h4>
                                    <ul class="d-list">
                                        <li>Unlimited Email Accounts</li>
                                        <li>Free SSL</li>
                                        <li>cPanel + Softaculous</li>
                                        <li>Free & Easy Site Migration</li>
                                        <li>Unlimited Mysql Database</li>
                                        <li>Unlimited Subdomains</li>
                                        <li>99.9% Server Uptime</li>
                                        <li>Free Daily Backup</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6">
                            <div class="de_pricing-table type-2">
                                <div class="d-head">
                                    <h3>Plus</h3>
                                    <p>For those need to running multiple sites.
                                </div>
                                <div class="d-price">
                                    <h4 class="opt-1">4.50$<span>/Month</span></h4>
                                    <h4 class="opt-2">45.00$<span>/Year</span></h4>
                                    <p>Normally <s>19$/ Monthly</s></p>
                                </div>
                                <div class="d-action">
                                    <a href="#PRODUCTLINK" class="btn-main opt-1 w-100">Get Monthly Plan</a>
                                    <a href="#PRODUCTLINK" class="btn-main opt-2 w-100">Get Yearly Plan</a>
                                    <p>re-new at same rate</p>
                                </div>
                                <div class="d-group">
                                    <h4>Top Features</h4>
                                    <ul class="d-list">
                                        <li>10 Websites</li>
                                        <li>Unmetered Storage</li>
                                        <li>Unmetered Bandwidth</li>
                                        <li>24/7 Customer Support</li>
                                    </ul>
                                </div>
                                <div class="d-group">
                                    <h4>Also Includes</h4>
                                    <ul class="d-list">
                                        <li>Unlimited Email Accounts</li>
                                        <li>Free SSL</li>
                                        <li>cPanel + Softaculous</li>
                                        <li>Free & Easy Site Migration</li>
                                        <li>Unlimited Mysql Database</li>
                                        <li>Unlimited Subdomains</li>
                                        <li>99.9% Server Uptime</li>
                                        <li>Free Daily Backup</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6">
                            <div class="de_pricing-table type-2">
                                <div class="d-recommend">Recommended</div>
                                <div class="d-head">
                                    <h3>Pro</h3>
                                    <p>Unlimited sites with automated backup.</p>
                                </div>
                                <div class="d-price">
                                    <h4 class="opt-1">6.50$<span>/Month</span></h4>
                                    <h4 class="opt-2">62.00$<span>/Year</span></h4>
                                    <p>Normally <s>29$ / Monthly</s></p>
                                </div>
                                <div class="d-action">
                                    <a href="#PRODUCTLINK" class="btn-main opt-1 w-100">Get Monthly Plan</a>
                                    <a href="#PRODUCTLINK" class="btn-main opt-2 w-100">Get Yearly Plan</a>
                                    <p>re-new at same rate</p>
                                </div>
                                <div class="d-group">
                                    <h4>Top Features</h4>
                                    <ul class="d-list">
                                        <li>Unlimited Websites</li>
                                        <li>Unmetered Storage</li>
                                        <li>Unmetered Bandwidth</li>
                                        <li>24/7 Customer Support</li>
                                    </ul>
                                </div>
                                <div class="d-group">
                                    <h4>Also Includes</h4>
                                    <ul class="d-list">
                                        <li>Unlimited Email Accounts</li>
                                        <li>Free SSL</li>
                                        <li>cPanel + Softaculous</li>
                                        <li>Free & Easy Site Migration</li>
                                        <li>Unlimited Mysql Database</li>
                                        <li>Unlimited Subdomains</li>
                                        <li>99.9% Server Uptime</li>
                                        <li>Free Daily</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <p class="text-danger text-center"><strong>*All Plan Prices In US$</strong></p>
                </div>
            </section>


            <section id="section-steps" class="no-top">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h5 class="s2">Easy Steps</h5>
                            <h2>How It Works</h2>
                            <p class="lead">Easy hosting made simple: streamlined steps for seamless website setup and management.</p>
                            <div class="spacer-20"></div>
                        </div>
                        <div class="col-md-12 wow fadeInUp">
                            <div class="container-timeline">
                                <ul>
                                    <li>
                                        <h4>Select Plan</h4>
                                        <p>Selecting the right hosting plan for the success of your website. Tailored to meet your specific needs.</p>
                                    </li>
                                    <li>
                                        <h4>Choose Domain</h4>
                                        <p>Choose a domain name that reflects your website's purpose, content, or the nature of your business.</p>
                                    </li>
                                    <li>
                                        <h4>Login/Register</h4>
                                        <p>Take the first step towards creating your website and reaching a wider audience by registering today.</p>
                                    </li>
                                    <li>
                                        <h4>Make Payment</h4>
                                        <p>We offer a variety of secure payment methods to make your payment process convenient and hassle-free.</p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="section-locations" class="no-top no-bottom" data-bgimage='url(images/background/1.jpg) top'>
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3">
                            <div class="col text-center">
                                <h5 class="s2">Discover</h5>
                                <h2>Server Locations</h2>
                                <p class="lead">Global reach, local performance: accelerate your website's speed and user experience with strategic server locations worldwide.</p>
                                <div class="spacer-20"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 wow fadeInUp">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <div class="de-map-hotspot">

                                    <div class="de-spot wow fadeIn" style="top:24%; left:53%">
                                        <span>Finland</span>
                                        <div class="de-circle-1"></div>
                                        <div class="de-circle-2"></div>
                                    </div>
                                   
                                    <img src="images/misc/map.png" class="img-fluid" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="spacer-double"></div>
                </div>
            </section>
            <section id="section-icons" class="no-top">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="row wow fadeInDown">
                                <div class="col-lg-4 col-md-4 text-center">
                                    <i class="icon-alarmclock de-icon mb20"></i>
                                    <h4>No Time Lost</h4>
                                    <p class="d-small">Reduce downtime with our efficient hosting solutions, ensuring your website is always available to visitors.</p>
                                </div>
                                <div class="col-lg-4 col-md-4 text-center">
                                    <i class="icon-refresh de-icon mb20"></i>
                                    <h4>Stay Online</h4>
                                    <p class="d-small">Stay Online: Benefit from reliable hosting services that keep your website operational around the clock.</p>
                                </div>
                                <div class="col-lg-4 col-md-4 text-center">
                                    <i class="icon-cloud de-icon mb20"></i>
                                    <h4>Daily Backup</h4>
                                    <p class="d-small">Ensure data security with daily backups, protecting your website's information from unexpected data loss.</p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </section>
            <section id="section-banner" class="no-bottom no-top" data-bgcolor="#DBEDF7">
                <div class="container">
                    <div class="row align-items-center g-custom-x">
                        <div class="col-lg-5 d-none d-lg-block d-xl-block  text-center">
                            <img class="relative img-fluid mt-60" src="images/misc/2.png" alt="">
                        </div>

                        <div class="col-lg-7">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <div class="spacer-20"></div>
                                <h5>Stop worries, you're covered with</h5>
                                <h2><span class="color-gradient">30 days</span> money back guarantee</h2>
                                <a class="btn-main" href="Shared-Hosting">Get Started</a>
                                <p class="d-small mt20">*Cancellation must be within a maximum of 30 days</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="section-faq">
                <div class="container">
                    <div class="row">
                        <div class="col text-center">
                            <h5 class="s2">Do You Have</h5>
                            <h2>Any Questions?</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row g-custom-x">
                        <div class="col-lg-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-1">
                                        How do I get started with web hosting?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-1">
                                        <p>To get started with web hosting:</p>
                                        <ol>
                                            <li>Register a domain name that reflects your brand.</li>
                                            <li>Select a hosting package that fits your website's needs.</li>
                                            <li>Configure your domain with your hosting provider.</li>
                                            <li>Enjoy reliable web hosting service and manage your website effortlessly.</li>
                                        </ol>
                                    </div>

                                    <div class="accordion-section-title" data-tab="#accordion-2">
                                        What is the difference between each hosting plan?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-2">
                                        <p>The main differences between hosting plans typically involve the amount of server resources allocated (such as CPU, RAM, and storage), the level of technical support provided, and any additional features like SSL certificates or email accounts. It's important to choose a plan that matches your website's traffic volume and performance requirements.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-3">
                                        What kind of web hosting do I need?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-3">
                                        <p>The type of web hosting you need depends on your website's size, traffic volume, and specific requirements. Shared hosting is suitable for small to medium-sized websites with moderate traffic. VPS hosting provides more resources and flexibility for growing websites. Dedicated servers offer maximum performance and control for large-scale websites or applications.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-b-4">
                                        Why do I need a domain name?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-4">
                                        <p>A domain name is your website's unique address on the internet (e.g., www.yourwebsite.com). It allows visitors to find and access your website easily. Having a domain name also helps establish your brand identity and credibility online. It's essential for creating a professional online presence and building trust with your audience.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-5">
                                        Is my website protected from hackers?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-5">
                                        <p>Yes, your website is protected. We implement multiple security measures, including:</p>
                                        <ul>
                                            <li>Imunify360 for comprehensive server protection.</li>
                                            <li>Litespeed Web Application Firewall (WAF) for enhanced security.</li>
                                            <li>Regular security audits and monitoring to detect and mitigate vulnerabilities proactively.</li>
                                        </ul>
                                        <p>These measures ensure your website remains secure against potential threats and maintains data integrity.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-6">
                                        How do I backup my website?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-6">
                                        <p>Backing up your website is essential to prevent data loss. Here's how to do it:</p>
                                        <ul>
                                            <li><strong>cPanel:</strong> Log in to cPanel, navigate to the Backup section, and use tools like Backup Wizard or Backup Manager to create and manage backups.</li>
                                            <li><strong>Plesk:</strong> Access Plesk, go to the Websites & Domains tab, select Backup Manager, and follow prompts to schedule and manage backups of your website files and databases.</li>
                                        </ul>
                                        <p>Regular backups ensure you can restore your website quickly in case of server issues, security breaches, or accidental data loss.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <!-- content close -->
        <a href="#" id="back-to-top"></a>
        <!-- footer begin -->
        <?php include 'include/footer.php'; ?>
        <!-- footer close -->
    </div>

    <!-- Javascript Files
    ================================================== -->
    <script src="js/plugins.js"></script>
    <script src="js/designesia.js"></script>
    <script>
        jQuery(document).ready(function() {
            $(function() {
                // jquery typed plugin
                $(".typed").typed({
                    stringsElement: $('.typed-strings'),
                    typeSpeed: 100,
                    backDelay: 500,
                    loop: true,
                    contentType: 'html', // or text
                    // defaults to false for infinite loop
                    loopCount: false,
                    callback: function() {
                        null;
                    },
                    resetCallback: function() {
                        newTyped();
                    }
                });
            });
        });
    </script>
</body>

</html>