<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>WordPress Hosting - RomaHost</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="WordPress Hosting - RomaHost" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>

            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Wordpress Hosting</h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Optimized hosting for WordPress sites.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">
                <div class="container">

                    <div class="spacer-10"></div>
                    <div class="row g-custom-x">
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-sm-30">
                            <div class="pricing-table pricing-s1">
                                <div class="top">
                                    <h3>Starter Plan</h3>
                                </div>
                                <div class="mid">
                                    <p class="price">
                                        <span class="currency">$</span>
                                        <span class="m opt-1">4.00</span>
                                        <span class="period">Per Month</span>
                                    </p>
                                </div>
                                <div class="bottom">
                                    <ul>
                                        <li><i class="fa fa-check"></i><strong>1</strong> Website</li>
                                        <li><i class="fa fa-check"></i><strong>10 GB</strong> Disk Space</li>
                                        <li><i class="fa fa-check"></i><strong>Unmetered </strong> Bandwiwith</li>
                                        <li><i class="fa fa-check"></i><strong>Unlimited</strong> MySql Database</li>
                                        <li><i class="fa fa-check"></i><strong>cPanel</strong> +
                                            <strong>Softaculous</strong>
                                        </li>
                                        <li><i class="fa fa-check"></i><strong>Daily</strong> Backups </li>
                                        <li><i class="fa fa-check"></i><strong>Free</strong> SSL certificate</li>
                                        </li>
                                    </ul>
                                </div>
                                <div class="action">
                                    <a href="#PRODUCTLINK" class="btn-main">Purchase Plan</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-sm-30">
                            <div class="pricing-table pricing-s1 table-featured">
                                <div class="top">
                                    <h3>Standard Plan</h3>
                                </div>
                                <div class="mid">
                                    <p class="price">
                                        <span class="currency">$</span>
                                        <span class="m opt-1">5.50</span>
                                        <span class="period">Per Month</span>
                                    </p>
                                </div>
                                <div class="bottom">
                                    <ul>
                                        <li><i class="fa fa-check"></i><strong>10</strong> Websites</li>
                                        <li><i class="fa fa-check"></i><strong>30 GB</strong> Disk Space</li>
                                        <li><i class="fa fa-check"></i><strong>Unmetered </strong> Bandwiwith</li>
                                        <li><i class="fa fa-check"></i><strong>Unlimited</strong> MySql Database</li>
                                        <li><i class="fa fa-check"></i><strong>cPanel</strong> +
                                            <strong>Softaculous</strong>
                                        </li>
                                        <li><i class="fa fa-check"></i><strong>Daily</strong> Backups </li>
                                        <li><i class="fa fa-check"></i><strong>Free</strong> SSL certificate</li>
                                    </ul>
                                </div>
                                <div class="action">
                                    <a href="#PRODUCTLINK" class="btn-main">Purchase Plan</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-12 mb-sm-30">
                            <div class="pricing-table pricing-s1">
                                <div class="top">
                                    <h3>Business Plan</h3>
                                </div>
                                <div class="mid">
                                    <p class="price">
                                        <span class="currency">$</span>
                                        <span class="m opt-1">7.50</span>
                                        <span class="period">Per Month</span>
                                    </p>
                                </div>
                                <div class="bottom">
                                    <ul>
                                        <li><i class="fa fa-check"></i><strong>Unlimited </strong> Websites</li>
                                        <li><i class="fa fa-check"></i><strong>Unmetered</strong> Disk Space</li>
                                        <li><i class="fa fa-check"></i><strong>Unmetered </strong> Bandwiwith</li>
                                        <li><i class="fa fa-check"></i><strong>Unlimited</strong> MySql Database</li>
                                        <li><i class="fa fa-check"></i><strong>cPanel</strong> +
                                            <strong>Softaculous</strong>
                                        </li>
                                        <li><i class="fa fa-check"></i><strong>Daily</strong> Backups </li>
                                        <li><i class="fa fa-check"></i><strong>Free</strong> SSL certificate</li>
                                    </ul>
                                </div>
                                <div class="action">
                                    <a href="#PRODUCTLINK" class="btn-main">Purchase Plan</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <p class="text-danger text-center"><strong>*All Plan Prices In US$</strong></p>
            </section>

            <section id="section-steps" class="no-top">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h5 class="s2">Easy Steps</h5>
                            <h2>Features that brings maximum power to your website.</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <i class="icon-alarmclock de-icon mb20"></i>
                            <h4>Instant Activation</h4>
                            <p>Instant hosting activation allows for quick setup of web hosting without any delay. Users
                                can immediately start uploading website files and making their site live on the
                                internet. This convenient feature saves time compared to traditional hosting setups.</p>
                        </div>
                        <div class="col-md-3">
                            <i class="icon-refresh de-icon mb20"></i>
                            <h4>99.99% Server Uptime</h4>
                            <p>99.99% server uptime means a server is operational 99.95% of the time with max 2 downtime
                                of downtime per month. This is important for websites to ensure accessibility and
                                improve user experience.</p>
                        </div>
                        <div class="col-md-3">
                            <i class="icon-layers de-icon mb20"></i>
                            <h4>LiteSpeed Web Server</h4>
                            <p>LiteSpeed Web Server is a high-performance web server software designed for websites with
                                high traffic and demanding applications. It offers improved speed, security, and
                                reliability compared to traditional web servers such as Apache. </p>
                        </div>
                        <div class="col-md-3">
                            <i class="icon-cloud de-icon mb20"></i>
                            <h4>Daily Database Backup</h4>
                            <p>Daily database backups refer to regularly creating and saving a copy of a database. This
                                is done to protect data in case of system failure, human error, or malicious attacks.
                            </p>
                        </div>
                    </div>
                </div>
            </section>


            <section id="section-faq">
                <div class="container">
                    <div class="row">
                        <div class="col text-center">
                            <h5 class="s2">Do You Have</h5>
                            <h2>Any Questions?</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row g-custom-x">
                        <div class="col-md-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-1">
                                        How do I get started with web hosting?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-1">
                                        <p>To get started with web hosting, you will need to choose a web hosting
                                            provider and purchase a hosting plan. Once you have chosen a provider and
                                            plan, you will need to register a domain name (if you don't already have
                                            one) and set up your account with the provider. After that, you can upload
                                            your website files to the server and make them live on the internet using
                                            SarHost. It is also very important to keep your web hosting updated
                                            and maintained, as well as securing your website to ensure it runs smoothly
                                            and is protected from any potential security threats.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-2">
                                        What is difference for each plan?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-2">
                                        <p>The difference between web hosting plans can vary, but generally, plans will
                                            differ in terms of the amount of storage space, bandwidth, and features
                                            offered. Storage space refers to the amount of disk space available to store
                                            your website files and bandwidth is the amount of data that can be
                                            transferred to and from your website each month. Some other common features
                                            that may vary between plans include: the number of websites, email accounts,
                                            SSL certificate, control panel and backup options. It's important to
                                            evaluate your website's specific needs and compare them to the features
                                            offered by different plans before making a decision.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-3">
                                        What kind of web hosting do I need?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-3">
                                        <p>The type of web hosting you need depends on the specific needs of your
                                            website. Here are a few options:
                                            <li>Shared hosting: Suitable for small to medium-sized websites with low to
                                                moderate traffic.</li>
                                            <li>VPS hosting: Suitable for medium-sized websites with moderate to high
                                                traffic.</li>
                                            <li>Dedicated hosting: Suitable for large websites with high traffic.</li>
                                            <li>Cloud hosting: Suitable for websites that experience fluctuating traffic
                                                and need scalability.</li>
                                            </ul><br>
                                            It's important to consider your website's traffic, performance, security,
                                            and scalability requirements before choosing a web hosting service.
                                        </p>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-b-4">
                                        Why do I need domain name?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-4">
                                        <p>
                                        <ol>
                                            <li>Branding: A domain name helps to establish your brand and create a
                                                memorable and professional image for your business.</li>
                                            <li>Identity: A domain name gives your website a unique identity and sets it
                                                apart from the millions of other websites on the internet.</li>
                                            <li>Search Engine Optimization: A domain name that is relevant to your
                                                business can improve your search engine rankings and make it easier for
                                                customers to find your website.</li>
                                            <li>Email Address: You can use your domain name to create
                                                professional-looking email addresses, such as help@SarHost.shop.
                                            </li>
                                            <li>Credibility: Having a domain name can add credibility to your business,
                                                making it more likely that customers will trust your website and do
                                                business with you.</li>
                                        </ol>
                                        </p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-5">
                                        What my website protected from hackers?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-5">
                                        <p>
                                        <ol>
                                            <li>Keep your website software and plugins up-to-date.</li>
                                            <li>Use a strong password and change it regularly.</li>
                                            <li>Use a reputable web host with security measures in place.</li>
                                            <li>Use a web application firewall (WAF) to protect against common attacks.
                                            </li>
                                            <li>Regularly backup your website and store the backup in a safe place.</li>
                                            <li>Use two-factor authentication for login.</li>
                                            <li>Regularly monitor your website for any suspicious activity.</li>
                                            <li>Use HTTPS to encrypt communication between the browser and the server.
                                            </li>
                                        </ol>
                                        </p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-6">
                                        How do I backup my website?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-6">
                                        <p>
                                        <ol>
                                            <li>Log in to your cPanel account.</li>
                                            <li>Scroll down to the "Files" section and click on the "Backup" icon.</li>
                                            <li>In the "Full Backup" section, click on the "Download a Full Website
                                                Backup" button.</li>
                                            <li>Select the destination for the backup file (e.g. home directory or
                                                remote FTP server) and click on the "Generate Backup" button.</li>
                                            <li>Once the backup is complete, you will be able to download the backup
                                                file to your local computer.</li>
                                        </ol>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-banner" class="no-bottom no-top" data-bgcolor="#DBEDF7">
                <div class="container">
                    <div class="row align-items-center g-custom-x">
                        <div class="col-lg-4 d-none d-lg-block d-xl-block  text-center">
                            <img class="relative img-fluid mt-60" src="images/misc/1.png" alt="">
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="p-sm-30 pb-sm-0 mb-sm-0">
                                <h2><span class="color-gradient">3 days</span> money back guarantee</h2>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="p-sm-30">
                                <div class="spacer-20 sm-hide"></div>
                                <p class="lead">If you not satisfy, we will refund your payment. No hassle, no risk. You
                                    can cancel plan at any time.</p>
                                <div class="spacer-half"></div>
                                <a class="btn-main" href="shared-hosting">Get Started</a>
                                <p class="d-small mt20">*Cancellation must be within a maximum of 3 days</p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>

        <!-- content close -->
        <a href="#" id="back-to-top"></a>
        <!-- footer begin -->
        <?php include 'include/footer.php'; ?>
        <!-- footer close -->
    </div>

    <!-- Javascript Files
    ================================================== -->
    <script src="js/plugins.js"></script>
    <script src="js/designesia.js"></script>
    <script>
        jQuery(document).ready(function() {
            $(function() {
                // jquery typed plugin
                $(".typed").typed({
                    stringsElement: $('.typed-strings'),
                    typeSpeed: 100,
                    backDelay: 500,
                    loop: true,
                    contentType: 'html', // or text
                    // defaults to false for infinite loop
                    loopCount: false,
                    callback: function() {
                        null;
                    },
                    resetCallback: function() {
                        newTyped();
                    }
                });
            });
        });
    </script>
</body>

</html>