<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Política de Privacidade - Roma Host</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Política de Privacidade - Roma Host" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">    <link href="css/roma.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Política de Privacidade</h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Descubra como protegemos seus dados e privacidade.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">

            <div class="dipeshc bg-white">
                <p>
                    Esta Política de Privacidade descreve como suas informações pessoais são coletadas, usadas e compartilhadas quando você visita ou faz uma compra na Roma Host. Esta política de privacidade foi compilada para melhor atender aqueles que estão preocupados com a forma como suas 'Informações de identificação pessoal' (PII) estão sendo usadas online. PII, conforme usado na lei de privacidade e segurança da informação, são informações que podem ser usadas sozinhas ou com outras informações para identificar, contatar ou localizar uma única pessoa, ou para identificar um indivíduo em contexto.
                </p>
                <p>
                    Leia nossa política de privacidade com atenção para entender claramente como coletamos, usamos, protegemos ou tratamos suas Informações Pessoais Identificáveis de acordo com nosso site.
                </p>
                <p>
                    <strong>Que informações pessoais coletamos das pessoas que visitam nosso blog, site ou aplicativo?</strong>
                </p>
                <p>
                    Ao fazer um pedido ou se registrar em nosso site, conforme apropriado, você poderá ser solicitado a inserir seu nome, endereço de e-mail, endereço para correspondência, número de telefone ou outros detalhes para ajudar em sua experiência.
                </p>

                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Quando coletamos informações?</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Coletamos informações suas quando você faz um pedido ou insere informações em nosso site. 
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Como usamos sua informação?</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Podemos usar as informações que coletamos de você quando você se registra, faz uma compra, se inscreve em nosso newsletter, responde a uma pesquisa ou comunicação de marketing, navega no site ou usa certos outros recursos do site das seguintes maneiras. Para personalizar a experiência do usuário e nos permitir entregar o tipo de conteúdo e ofertas de produtos nos quais você está mais interessado. Para processar rapidamente suas transações. Para enviar e-mails periódicos sobre seu pedido ou outros produtos e serviços.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Protegemos as informações dos visitantes?</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Nosso site é escaneado regularmente em busca de falhas de segurança e vulnerabilidades conhecidas para tornar sua visita ao nosso site o mais segura possível. Usamos o Malware Scanning regularmente. Suas informações pessoais estão contidas atrás de redes seguras e são acessíveis apenas por um número limitado de pessoas que têm direitos especiais de acesso a tais sistemas e são obrigadas a manter as informações confidenciais.
                        </p>
                        <p>
                            Além disso, todas as informações sensíveis e de crédito que você fornece são criptografadas por meio da tecnologia Secure Socket Layer (SSL). Implementamos uma variedade de medidas de segurança quando um usuário faz um pedido, insere, envia ou acessa suas informações para manter a segurança de suas informações pessoais. Todas as transações são processadas por meio de um provedor de gateway e não são armazenadas ou processadas em nossos servidores.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Usamos cookies?</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Sim. Cookies são pequenos arquivos que um site ou seu provedor de serviços transfere para o disco rígido do seu computador por meio do seu navegador da Web (se você permitir), o que permite que os sistemas do site ou do provedor de serviços reconheçam seu navegador e capturem e lembrem de certas informações.
                        </p>
                        <p>
                            Por exemplo, usamos cookies para nos ajudar a lembrar e processar os itens no seu carrinho de compras. Eles também são usados para nos ajudar a entender suas preferências com base na atividade anterior ou atual do site, o que nos permite fornecer serviços aprimorados.
                        </p>
                        <p>
                            Também utilizamos cookies para nos ajudar a compilar dados agregados sobre o tráfego e a interação do site, para que possamos oferecer melhores experiências e ferramentas no site no futuro.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Usamos cookies para?</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Ajude a lembrar e processar os itens no carrinho de compras. Entenda e salve as preferências do usuário para futuras visitas. Compile dados agregados sobre o tráfego do site e as interações do site para oferecer melhores experiências e ferramentas no site no futuro. Também podemos usar serviços de terceiros confiáveis que rastreiam essas informações em nosso nome.
                        </p>
                        <p>
                            Você pode escolher que seu computador o avise sempre que um cookie estiver sendo enviado, ou pode escolher desativar todos os cookies. Você faz isso por meio das configurações do seu navegador (como o Internet Explorer). Cada navegador é um pouco diferente, então consulte o menu Ajuda do seu navegador para aprender a maneira correta de modificar seus cookies.
                        </p>
                        <p>
                            Se você desabilitar os cookies, alguns recursos serão desabilitados. Isso não afetará a experiência do usuário, o que tornará a experiência do seu site mais eficiente e alguns dos nossos serviços não funcionarão corretamente.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Arquivos de Log</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Como acontece com a maioria dos sites, coletamos determinadas informações automaticamente e as armazenamos em arquivos de log. Essas informações incluem endereços de protocolo de Internet (IP), tipo de navegador, provedor de serviços de Internet (ISP), páginas de referência/saída, sistema operacional, carimbo de data/hora e dados de fluxo de cliques. Utilizamos essas informações, que não identificam usuários individuais, para analisar tendências, administrar o site, rastrear os movimentos dos usuários no site e coletar informações demográficas sobre nossa base de usuários como um todo. Não vinculamos esses dados coletados automaticamente a informações de identificação pessoal.
                        </p>
                        <p>
                            Os endereços IP estão vinculados a informações de identificação pessoal para evitar e impedir que abusadores continuem usando nossos serviços, como membros que violam nossos termos de serviço. Utilizamos um serviço de rastreamento de terceiros que utiliza cookies e arquivos de log para rastrear informações não pessoalmente identificáveis sobre os visitantes do nosso site no agregado de estatísticas de uso e volume para determinar como nossos usuários navegam em nosso site e para saber quantos usuários estão usando nossos serviços demograficamente.
                        </p>
                        <p>
                            Usamos as informações que você fornece sobre si mesmo ou outros para concluir a transação para a qual se destina. Isso pode incluir administrar um serviço como registro, e-mail, fórum etc., ou contatá-lo se você tiver indicado sua permissão para fazê-lo ao concordar em aceitar mais notificações e anúncios de serviço de nós em sua página de perfil de membro.
                        </p>
                        <p>
                            Você pode escolher cancelar o recebimento de qualquer notificação adicional da sua página de perfil de membro. Não compartilhamos essas informações com a parte externa.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Pesquisas</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Ao usar nossos serviços, você pode ser solicitado a participar de nossas pesquisas internas periódicas que são conduzidas pela Roma Host para determinar seus interesses. Essas pesquisas são estritamente voluntárias. Os dados coletados por meio dessas pesquisas serão usados apenas para melhorar nossos produtos e serviços e nunca serão vendidos a terceiros.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Divulgação de terceiros</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Não vendemos, comercializamos ou de outra forma transferimos a terceiros suas informações de identificação pessoal, a menos que forneçamos aviso prévio aos usuários. Isso não inclui parceiros de hospedagem de sites e outras partes que nos auxiliam na operação de nosso site, na condução de nossos negócios ou no atendimento aos nossos usuários, desde que essas partes concordem em manter essas informações confidenciais.
                        </p>
                        <p>
                            Também podemos divulgar informações quando sua divulgação for apropriada para cumprir a lei, fazer cumprir as políticas do nosso site ou proteger os direitos, propriedade ou segurança nossos ou de terceiros. No entanto, informações não pessoalmente identificáveis do visitante podem ser fornecidas a terceiros para fins de marketing, publicidade ou outros usos.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Links de terceiros</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Ocasionalmente, a nosso critério, poderemos incluir ou oferecer produtos ou serviços de terceiros em nosso site. Esses sites de terceiros possuem políticas de privacidade separadas e independentes.
                        </p>
                        <p>
                            Portanto, não temos nenhuma responsabilidade ou obrigação pelo conteúdo e atividades desses sites vinculados. No entanto, buscamos proteger a integridade do nosso site e agradecemos qualquer feedback sobre esses sites.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Lei CAN-SPAM</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            A Lei CAN-SPAM é uma lei que define as regras para e-mails comerciais, estabelece requisitos para mensagens comerciais, dá aos destinatários o direito de impedir que e-mails sejam enviados a eles e define penalidades severas para violações.
                        </p>
                        <p>
                            Coletamos seu endereço de e-mail para estar sob CANSPAM, concordamos com o seguinte. Se a qualquer momento você quiser cancelar a assinatura para receber e-mails futuros, você pode nos enviar um e-mail e nós o removeremos prontamente de TODA a correspondência.
                        </p>
                    </div>
                </div>
                <div class="dipesh1-main">
                    <div class="dipesh1-head text-center">
                        <h2>Alterações nesta Política de Privacidade</h2>
                    </div>
                    <div class="dipesh1-content">
                        <p>
                            Se decidirmos alterar nossa política de privacidade, publicaremos essas alterações nesta declaração de privacidade, na página inicial e em outros lugares que considerarmos apropriados para que você saiba quais informações coletamos, como as usamos e em quais circunstâncias, se houver, as divulgamos.
                        </p>
                        <p>
                            Reservamo-nos o direito de modificar esta declaração de privacidade a qualquer momento, portanto, revise-a com frequência. Se fizermos alterações materiais nesta política, iremos notificá-lo aqui, por e-mail ou através de um aviso em nossa página inicial. Para mais informações não hesite em enviar as suas questões através do nosso formulário de contato.
                        </p>
                    </div>
                </div>
                <strong>
                    <font color="#fc0000">Última atualização em 27<sup></sup>-Agosto-2024 </font>
                </strong>
            </div>
            </section>
            <!-- content close -->
            <a href="#" id="back-to-top"></a>
            <!-- footer begin -->
            <?php include 'include/footer.php'; ?>
            <!-- footer close -->
        </div>

        <!-- Javascript Files
    ================================================== -->
        <script src="js/plugins.js"></script>
        <script src="js/designesia.js"></script>
        <script>
            jQuery(document).ready(function() {
                $(function() {
                    // jquery typed plugin
                    $(".typed").typed({
                        stringsElement: $('.typed-strings'),
                        typeSpeed: 100,
                        backDelay: 500,
                        loop: true,
                        contentType: 'html', // or text
                        // defaults to false for infinite loop
                        loopCount: false,
                        callback: function() {
                            null;
                        },
                        resetCallback: function() {
                            newTyped();
                        }
                    });
                });
            });
        </script>
</body>

</html>