<!DOCTYPE html>
<html lang="zxx">

<head>
    <title>Cupons de Descontos - Roma Host</title>
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Cupons de Descontos - Roma Host" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
    <link href="css/offer.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-loader"></div>
        <!-- page preloader close -->
        <!-- header begin -->
        <?php include 'include/header.php'; ?>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="subheader" class="jarallax">
                <img src="images/background/2subheader2.jpg" class="jarallax-img" alt="">
                <div class="center-y relative text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <h1>Cupons de Descontos </h1>
                            </div>
                            <div class="col-lg-6 offset-lg-3">
                                <p class="lead">Descubra nossas políticas e diretrizes para uso do serviço.</p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-hero" class="no-top mt-100" aria-label="section">
                <div class="container no-top">
                    <div class="row align-items-center">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="row">'
                                <div class="coupon-card style1">
                                    <h3 class="text-white">Style 1</h3>
                                    <div class="coupon-row">
                                        <span id="cpnCode">ROMA50</span>
                                        <span id="cpnBtn">Copiar Código</span>
                                    </div>
                                    <p class="countdown" data-expiry="2024-08-31">Tempo Restante: </p>
                                    <div class="circle1"></div>
                                    <div class="circle2"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-10 offset-lg-1">
                            <div class="row">'
                                <div class="coupon-card style2">
                                    <h3>Style 2</h3>
                                    <div class="coupon-row">
                                        <span id="cpnCode">ROMA50</span>
                                        <span id="cpnBtn">Copiar Código</span>
                                    </div>
                                    <p class="countdown" data-expiry="2024-08-31">Tempo Restante: </p>
                                    <div class="circle1"></div>
                                    <div class="circle2"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-10 offset-lg-1">
                            <div class="row">'
                                <div class="coupon-card style3">
                                    <h3 class="text-white">Style 3</h3>
                                    <div class="coupon-row">
                                        <span id="cpnCode">ROMA50</span>
                                        <span id="cpnBtn">Copiar Código</span>
                                    </div>
                                    <p class="countdown" data-expiry="2024-07-31">Tempo Restante: </p>
                                    <div class="circle1"></div>
                                    <div class="circle2"></div>
                                </div>
                            </div>
                        </div>
                    </div><br>
                    <div id="top"></div>
                    <div class="dipeshc bg-white">
                        <p></p>
                        <p><strong>Lembramos que todas as compras feitas com código promocional no Roma Host não são reembolsáveis. Certifique-se de verificar seu pedido antes de aplicar o código. Agradecemos a sua compreensão e obrigado por escolher a Roma Host para suas compras.</strong></p>
                    </div>
                </div>
            </section>
            <!-- content close -->
            <a href="#" id="back-to-top"></a>
            <!-- footer begin -->
            <?php include 'include/footer.php'; ?>
            <!-- footer close -->
        </div>

        <!-- Javascript Files
    ================================================== -->
        <script src="js/plugins.js"></script>
        <script src="js/designesia.js"></script>
        <script>
            // Wait for the DOM content to be fully loaded
            document.addEventListener('DOMContentLoaded', function() {
                // Select all copy buttons
                var copyButtons = document.querySelectorAll('.coupon-card #cpnBtn');

                // Loop through each copy button and attach an event listener
                copyButtons.forEach(function(btn) {
                    btn.addEventListener('click', function() {
                        // Get the coupon code
                        var code = btn.previousElementSibling.textContent.trim();

                        // Copy the coupon code to clipboard
                        navigator.clipboard.writeText(code)
                            .then(function() {
                                // Change button text to indicate successful copying
                                btn.textContent = "COPIED";
                                setTimeout(function() {
                                    // Reset button text after 3 seconds
                                    btn.textContent = "COPY CODE";
                                }, 3000);
                            })
                            .catch(function(error) {
                                // Handle any errors
                                console.error('Failed to copy: ', error);
                            });
                    });
                });
            });



            // Countdown Timer
            document.querySelectorAll('.countdown').forEach(timer => {
                const expiryDate = new Date(timer.dataset.expiry).getTime();

                const updateTimer = () => {
                    const now = new Date().getTime();
                    const distance = expiryDate - now;

                    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    timer.innerHTML = "Time Left: " + days + " Day " + hours + " Hours " + minutes + " Minutes " + seconds + " Seconds ";

                    if (distance < 0) {
                        clearInterval(timerInterval);
                        timer.innerHTML = "EXPIRED";
                    }
                };
                updateTimer();
                const timerInterval = setInterval(updateTimer, 1000);
            });
        </script>
</body>

</html>